#Before using this component, make sure to define the LAVAWALL_KEY variable for each site
#In Datto RMM, you can do this under Sitename > Settings > Variables.
#
#You can find the value for this key on the console under Computers > Downloads/Add
#in the Datto RMM for Windows section https://console.lavawall.com/agentdownloads.php
#
#For comprehensive instructions, see https://console.lavawall.com/datto_rmm.php
#
#If you run into any problems, feel free to use the chat within the Lavawall® console or call ThreeShield at 1-403-538-5053
#
# copyright (c) ThreeShield Information Security Corporation, 2025.  All rights reserved.
# 
$url = "https://lavawinupdate.lavawall.com/" + $env:LAVAWALL_KEY + ".zip"
echo "Downloading from $url"
$dest = Join-Path $env:TEMP "Lavawall.zip"
Invoke-WebRequest -Uri $url -OutFile $dest
Expand-Archive -Path $dest -DestinationPath $env:TEMP -Force

# Start the process and redirect output to stdout
$processInfo = New-Object System.Diagnostics.ProcessStartInfo
$processInfo.FileName = (Join-Path $env:TEMP "LavawallWin.exe")
$processInfo.RedirectStandardOutput = $true
$processInfo.UseShellExecute = $false

$process = New-Object System.Diagnostics.Process
$process.StartInfo = $processInfo
$process.Start() | Out-Null
$process.WaitForExit()

$stdout = $process.StandardOutput.ReadToEnd()
Write-Host $stdout
# Clean up
Remove-Item -Path $dest -Force
Remove-Item -Path (Join-Path $env:TEMP "LavawallWin.exe") -Force
